/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.efnilite.skematic.objects.PasteOptions;
import com.efnilite.skematic.objects.Schematic;
import com.efnilite.skematic.utils.FaweUtils;
import com.sk89q.worldedit.regions.CuboidRegion;
import java.util.Arrays;
import java.util.HashSet;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Paste cuboidregion")
@Description(value={"Paste a cuboidregion at a location. This can be the player's selection, etc."})
@Examples(value={"paste player's selection at player's location ignoring air and ignoring biomes and ignoring entities"})
@Since(value="2.1")
public class EffCuboidPaste
extends Effect {
    private Expression<CuboidRegion> cuboid;
    private Expression<Location> location;
    private Expression<PasteOptions> options;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.cuboid = expressions[0];
        this.location = expressions[1];
        this.options = expressions[2];
        return true;
    }

    protected void execute(Event e) {
        PasteOptions[] pasteOptionsArray;
        CuboidRegion cuboid = (CuboidRegion)this.cuboid.getSingle(e);
        Location location = (Location)this.location.getSingle(e);
        if (this.options != null) {
            pasteOptionsArray = (PasteOptions[])this.options.getArray(e);
        } else {
            PasteOptions[] pasteOptionsArray2 = new PasteOptions[1];
            pasteOptionsArray = pasteOptionsArray2;
            pasteOptionsArray2[0] = PasteOptions.DEFAULT;
        }
        PasteOptions[] options = pasteOptionsArray;
        if (cuboid == null || location == null) {
            return;
        }
        HashSet<PasteOptions> optionsSet = new HashSet<PasteOptions>(Arrays.asList(options));
        new Schematic(cuboid).paste(FaweUtils.getWorld(location.getWorld().getName()), FaweUtils.toVector(location), optionsSet);
    }

    public String toString(Event e, boolean debug) {
        return "paste " + this.cuboid.toString(e, debug) + " at " + this.location.toString(e, debug) + (this.options != null ? " with options " + this.options.toString(e, debug) : "");
    }

    static {
        Skript.registerEffect(EffCuboidPaste.class, (String[])new String[]{"paste %cuboidregions% at %location% [ignoring %-pasteoptions%]"});
    }
}

