/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.efnilite.skematic.utils.FaweUtils;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

@Name(value="Fill Region")
@Description(value={"Fill a region (selection) with a block."})
@Since(value="2.1")
public class EffCuboidFill
extends Effect {
    private Expression<CuboidRegion> cuboid;
    private Expression<ItemType> blocks;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.cuboid = expressions[0];
        this.blocks = expressions[1];
        return true;
    }

    protected void execute(Event e) {
        CuboidRegion cuboid = (CuboidRegion)this.cuboid.getSingle(e);
        ItemType[] blocks = (ItemType[])this.blocks.getArray(e);
        if (cuboid == null || blocks == null) {
            return;
        }
        EditSession session = FaweUtils.getEditSession(Bukkit.getServer().getWorld(cuboid.getWorld().getName()));
        session.setBlocks((Region)cuboid, FaweUtils.parsePattern(blocks));
        session.flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "fill " + this.cuboid.toString(e, debug) + " with " + this.blocks.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffCuboidFill.class, (String[])new String[]{"set [(all [[of] the]|the)] [(fawe|skematic)] blocks in %cuboidregions% to %itemtypes%"});
    }
}

