/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.boydti.fawe.bukkit.wrapper.AsyncWorld;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.event.Event;

@Name(value="AsyncWorld - Create")
@Description(value={"Create an AsyncWorld."})
@Examples(value={"create the async world called \"myworld\""})
@Since(value="1.0")
public class EffAsyncWorldCreate
extends Effect {
    private Expression<String> name;
    private Expression<World> world;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.name = expressions[0];
        if (parseResult.mark == 1) {
            this.world = expressions[1];
        }
        return true;
    }

    protected void execute(Event e) {
        String name = (String)this.name.getSingle(e);
        World world = (World)this.world.getSingle(e);
        if (name == null) {
            return;
        }
        if (world == null) {
            AsyncWorld.create((WorldCreator)new WorldCreator(name));
        } else {
            AsyncWorld.create((WorldCreator)new WorldCreator(name).copy(world));
        }
    }

    public String toString(Event e, boolean debug) {
        return "load world " + this.world.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffAsyncWorldCreate.class, (String[])new String[]{"(create|load) [the] [(fawe|skematic)]async[hronous] [world] [(called|named)] %strings% [(1\u00a6using [world[s]] %-world%)]", "(load|create) [(fawe|skematic)] world[s] [(called|named)] %strings% async[hronously] [(1\u00a6using [world[s]] %-world%)]"});
    }
}

