/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.efnilite.skematic.utils.FaweUtils;
import com.sk89q.worldedit.EditSession;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

@Name(value="Async Set")
@Description(value={"Set a block at a location using FAWE's API."})
@Since(value="2.3")
public class EffAsyncSet
extends Effect {
    private Expression<?> location;
    private Expression<ItemType> blocks;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.location = expressions[0];
        this.blocks = expressions[1];
        return true;
    }

    protected void execute(Event e) {
        Location location;
        ItemType[] blocks = (ItemType[])this.blocks.getArray(e);
        if (this.location.getSingle(e) == null || blocks == null) {
            return;
        }
        if (this.location.getSingle(e) instanceof Block) {
            location = ((Block)this.location.getSingle(e)).getLocation();
        } else if (this.location.getSingle(e) instanceof Location) {
            location = (Location)this.location.getSingle(e);
        } else {
            return;
        }
        EditSession session = FaweUtils.getEditSession(Bukkit.getServer().getWorld(location.getWorld().getName()));
        session.setBlock(FaweUtils.toVector(location), FaweUtils.parsePattern(blocks));
        session.flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "set " + this.location.toString(e, debug) + " to " + this.blocks.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffAsyncSet.class, (String[])new String[]{"set [the] [(fawe|skematic)] block[s] at %locations/blocks% to %itemtype%"});
    }
}

