/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.objects;

import com.boydti.fawe.object.clipboard.FaweClipboard;
import com.boydti.fawe.object.clipboard.ReadOnlyClipboard;
import com.efnilite.skematic.objects.PasteOptions;
import com.efnilite.skematic.utils.FaweUtils;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.world.World;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.bukkit.Bukkit;

public class Schematic {
    private File file;
    private Clipboard clipboard;

    public Schematic(File file) {
        this.file = file;
        this.clipboard = FaweUtils.toSchematic(file).getClipboard();
    }

    public Schematic(CuboidRegion cuboid) {
        this.file = null;
        this.clipboard = new BlockArrayClipboard((Region)cuboid, (FaweClipboard)ReadOnlyClipboard.of((EditSession)FaweUtils.getEditSession(Bukkit.getWorld((String)cuboid.getWorld().getName())), (Region)cuboid));
    }

    public void paste(World world, Vector vector, Set<PasteOptions> options) {
        new ClipboardHolder(this.clipboard, world.getWorldData()).createPaste((Extent)this.clipboard, world.getWorldData()).to(vector).ignoreAirBlocks(!options.contains((Object)PasteOptions.AIR)).ignoreEntities(!options.contains((Object)PasteOptions.ENTITIES)).ignoreBiomes(!options.contains((Object)PasteOptions.BIOMES)).build();
    }

    public void save(File file, ClipboardFormat format) {
        try {
            FaweUtils.toSchematic(file).save(file, format);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return this.file.toString();
    }

    public File getFile() {
        return this.file;
    }

    public Clipboard getClipboard() {
        return this.clipboard;
    }
}

