/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.boydti.fawe.FaweAPI;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import org.bukkit.entity.Player;

@Name(value="Selection")
@Description(value={"Gets the selection of a player (region)"})
@Since(value="1.0")
public class ExprSelection
extends SimplePropertyExpression<Player, CuboidRegion> {
    public CuboidRegion convert(Player p) {
        LocalSession session = FaweAPI.wrapPlayer((Object)p).getSession();
        try {
            Region selection = session.getSelection(session.getSelectionWorld());
            return new CuboidRegion(selection.getWorld(), selection.getMaximumPoint(), selection.getMaximumPoint());
        }
        catch (IncompleteRegionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Class<? extends CuboidRegion> getReturnType() {
        return CuboidRegion.class;
    }

    protected String getPropertyName() {
        return "selection";
    }

    static {
        ExprSelection.register(ExprSelection.class, CuboidRegion.class, (String)"[(skematic|fawe)] selection[s]", (String)"players");
    }
}

