/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.efnilite.skematic.objects.Schematic;
import com.efnilite.skematic.objects.SchematicLoader;
import com.sk89q.worldedit.Vector;
import java.io.File;
import java.nio.file.Paths;
import org.bukkit.event.Event;

@Name(value="Schematic size")
@Description(value={"Gets the size of a schematic."})
@Examples(value={"set {_size} to the size of skematic \"plugins/WorldEdit/ZAS.schematic\""})
@Since(value="1.0")
public class ExprSchematicSize
extends SimpleExpression<Vector> {
    private Expression<?> schematic;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.schematic = expressions[0];
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Vector[] get(Event e) {
        Schematic schematic;
        if (this.schematic.getSingle(e) instanceof String) {
            String file = (String)this.schematic.getSingle(e);
            if (SchematicLoader.getSchematics().containsKey(file)) {
                schematic = SchematicLoader.get(file);
                return new Vector[]{schematic.getClipboard().getOrigin()};
            } else {
                if (!Paths.get(file, new String[0]).toFile().exists()) {
                    Skript.error((String)("Schematic " + file + " doesn't exist!"));
                    return null;
                }
                schematic = new Schematic(new File(file));
            }
            return new Vector[]{schematic.getClipboard().getOrigin()};
        }
        if (!(this.schematic.getSingle(e) instanceof Schematic)) {
            return null;
        }
        schematic = (Schematic)this.schematic.getSingle(e);
        return new Vector[]{schematic.getClipboard().getOrigin()};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    public String toString(Event e, boolean debug) {
        return "size of " + this.schematic.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprSchematicSize.class, Vector.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[(skematic|fawe)] s(ch|k)em[atic] size of %schematics/strings%", "%schematics/strings%'[s] [(skematic|fawe)] s(ch|k)em[atic] size"});
    }
}

