/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.efnilite.skematic.objects.Schematic;
import com.efnilite.skematic.objects.SchematicLoader;
import com.sk89q.worldedit.Vector;
import java.io.File;
import java.nio.file.Paths;
import org.bukkit.event.Event;

@Name(value="Schematic dimensions")
@Description(value={"Gets one of the schematic dimensions (width, length or height)"})
@Examples(value={"set {_width} to the width of the skematic \"plugins/Transport/Berm.schematic\""})
@Since(value="1.0")
public class ExprSchematicArea
extends SimpleExpression<Number> {
    private int mark;
    private Expression<?> schematic;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.schematic = expressions[0];
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Number[] get(Event e) {
        double t;
        Schematic schematic;
        if (this.schematic.getSingle(e) instanceof String) {
            String file = (String)this.schematic.getSingle(e);
            if (SchematicLoader.getSchematics().containsKey(file)) {
                schematic = SchematicLoader.get(file);
            } else {
                if (!Paths.get(file, new String[0]).toFile().exists()) {
                    Skript.error((String)("Schematic " + file + " doesn't exist!"));
                    return null;
                }
                schematic = new Schematic(new File(file));
            }
        } else {
            if (!(this.schematic.getSingle(e) instanceof Schematic)) {
                return null;
            }
            schematic = (Schematic)this.schematic.getSingle(e);
        }
        Vector size = schematic.getClipboard().getDimensions();
        switch (this.mark) {
            case 1: {
                t = size.getY();
                return new Number[]{t};
            }
            case 2: {
                t = size.getX();
                return new Number[]{t};
            }
            case 3: {
                t = size.getZ();
                return new Number[]{t};
            }
            case 4: {
                t = size.getZ() * size.getX();
                return new Number[]{t};
            }
            default: {
                t = 0.0;
            }
        }
        return new Number[]{t};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public String toString(Event e, boolean debug) {
        return "areas of " + this.schematic.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprSchematicArea.class, Number.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] [(skematic|fawe)] (1\u00a6width|2\u00a6height|3\u00a6length|4\u00a6floor[(-| )]size) of [the] s(ch|k)em[atic] %schematics%"});
    }
}

