/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.efnilite.skematic.utils.FaweUtils;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.patterns.Pattern;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Shape - Line")
@Description(value={"Create a line between 2 locations"})
@Examples(value={"create a new hollow line from player's location to {_point 1} with quartz block and radius 2"})
@Since(value="2.0")
public class EffShapeLine
extends Effect {
    private int mark;
    private Expression<Location> location1;
    private Expression<Location> location2;
    private Expression<ItemType> blocks;
    private Expression<Number> radius;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.mark = parseResult.mark;
        this.location1 = expressions[0];
        this.location2 = expressions[1];
        this.blocks = expressions[2];
        this.radius = expressions[3];
        return true;
    }

    protected void execute(Event e) {
        Location location1 = (Location)this.location1.getSingle(e);
        Location location2 = (Location)this.location2.getSingle(e);
        ItemType[] blocks = (ItemType[])this.blocks.getArray(e);
        Number radius = (Number)this.radius.getSingle(e);
        boolean filled = true;
        if (blocks == null || radius == null) {
            return;
        }
        if (this.mark == 1) {
            filled = false;
        }
        EditSession session = FaweUtils.getEditSession(location1.getWorld());
        session.drawLine((Pattern)FaweUtils.parsePattern(blocks), FaweUtils.toVector(location1), FaweUtils.toVector(location2), (double)Math.round(((Long)radius).longValue()), filled);
        session.flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "create a line between " + this.location1.toString(e, debug) + " and " + this.location2.toString(e, debug) + " with pattern " + this.blocks.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffShapeLine.class, (String[])new String[]{"(make|create) [a] [new] [(1\u00a6hollow)] line from %location% to %location% (with|and) %itemtypes% [block[s]] (with|and) radius %number%"});
    }
}

