/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.efnilite.skematic.objects.PasteOptions;
import com.efnilite.skematic.objects.Schematic;
import com.efnilite.skematic.objects.SchematicLoader;
import com.efnilite.skematic.utils.FaweUtils;
import com.sk89q.worldedit.CuboidClipboard;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.world.DataException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Paste schematic")
@Description(value={"Paste a schematic at a location with or without using air"})
@Examples(value={"paste skematic \"plugins/WorldEdit/skematic.schematic\" at player excluding air"})
@Since(value="1.0")
public class EffSchematicPaste
extends Effect {
    private Expression<?> schematic;
    private Expression<Location> location;
    private Expression<PasteOptions> options;
    private Expression<Number> angle;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.schematic = expressions[0];
        this.location = expressions[1];
        this.options = expressions[2];
        this.angle = expressions[3];
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(Event e) {
        CuboidClipboard clipboard;
        Schematic schematic;
        PasteOptions[] pasteOptionsArray;
        Location location = (Location)this.location.getSingle(e);
        if (this.options != null) {
            pasteOptionsArray = (PasteOptions[])this.options.getArray(e);
        } else {
            PasteOptions[] pasteOptionsArray2 = new PasteOptions[1];
            pasteOptionsArray = pasteOptionsArray2;
            pasteOptionsArray2[0] = PasteOptions.DEFAULT;
        }
        PasteOptions[] options = pasteOptionsArray;
        Number angle = this.angle != null ? (Number)((Number)this.angle.getSingle(e)) : (Number)null;
        if (this.schematic == null) return;
        if (location == null) return;
        if (options == null) {
            return;
        }
        if (this.schematic.getSingle(e) instanceof String) {
            String file = (String)this.schematic.getSingle(e);
            if (SchematicLoader.getSchematics().containsKey(file)) {
                schematic = SchematicLoader.get(file);
            } else {
                if (!Paths.get(file, new String[0]).toFile().exists()) {
                    Skript.error((String)("Schematic " + file + " doesn't exist!"));
                    return;
                }
                schematic = new Schematic(new File(file));
            }
        } else {
            if (!(this.schematic.getSingle(e) instanceof Schematic)) return;
            schematic = (Schematic)this.schematic.getSingle(e);
        }
        HashSet<PasteOptions> optionsSet = new HashSet<PasteOptions>(Arrays.asList(options));
        Vector vector = FaweUtils.toVector(location);
        if (angle == null) {
            schematic.paste(FaweUtils.getWorld(location.getWorld().getName()), vector, optionsSet);
            return;
        }
        EditSession session = FaweUtils.getEditSession(location.getWorld());
        try {
            clipboard = CuboidClipboard.loadSchematic((File)schematic.getFile());
        }
        catch (DataException | IOException ex) {
            return;
        }
        clipboard.rotate2D(((Integer)angle).intValue());
        try {
            clipboard.paste(session, vector, !optionsSet.contains((Object)PasteOptions.AIR));
        }
        catch (MaxChangedBlocksException exception) {
            return;
        }
        session.flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "paste schematic " + this.schematic.toString(e, debug) + " at " + this.location.toString(e, debug) + (this.angle != null ? " with angle " + this.angle.toString(e, debug) : "");
    }

    static {
        Skript.registerEffect(EffSchematicPaste.class, (String[])new String[]{"paste [the] s(ch|k)em[atic] %strings/schematics% at %location% [ignoring %-pasteoptions%] [[with] angle %-number%]"});
    }
}

