/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.efnilite.skematic.utils.FaweUtils;
import com.sk89q.worldedit.EditSession;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Redo")
@Description(value={"Redo the last undo of a player."})
@Examples(value={"redo the last change of player"})
@Since(value="1.0")
public class EffRedo
extends Effect {
    private Expression<Player> player;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.player = expressions[0];
        return true;
    }

    protected void execute(Event e) {
        Player player = (Player)this.player.getSingle(e);
        if (player == null) {
            return;
        }
        EditSession session = FaweUtils.getPlayer(player).getNewEditSession();
        session.redo(FaweUtils.getPlayer(player).getNewEditSession());
        session.flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "redo last change of " + this.player.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffRedo.class, (String[])new String[]{"redo [the] last [(fawe|fastasyncworldedit)] ((action|change) of %player%|%player%'s (action|change))"});
    }
}

