/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.efnilite.skematic.utils.FaweUtils;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Flush Queue")
@Description(value={"Flush the queue of a player - clear it."})
@Examples(value={"flush player's queue"})
@Since(value="1.0")
public class EffFlush
extends Effect {
    private Expression<Player> player;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.player = expressions[0];
        return true;
    }

    protected void execute(Event e) {
        Player player = (Player)this.player.getSingle(e);
        if (player == null) {
            return;
        }
        FaweUtils.getPlayer(player).getNewEditSession().flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "flush queue of " + this.player.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffFlush.class, (String[])new String[]{"(flush|dequeue) [the] (queue of %player%|%player%'s queue)"});
    }
}

