/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.efnilite.skematic.utils.FaweUtils;
import com.sk89q.worldedit.EditSession;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Drain liquids")
@Description(value={"Drain all liquids at a certain location with a radius."})
@Examples(value={"drain all liquids at 124, 32, 12 in \"world\" in a radius of 10"})
@Since(value="2.0")
public class EffDrain
extends Effect {
    private Expression<Location> location;
    private Expression<Number> radius;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.location = expressions[0];
        this.radius = expressions[1];
        return true;
    }

    protected void execute(Event e) {
        Location location = (Location)this.location.getSingle(e);
        Number radius = (Number)this.radius.getSingle(e);
        if (radius == null) {
            return;
        }
        EditSession session = FaweUtils.getEditSession(location.getWorld());
        session.drainArea(FaweUtils.toVector(location), ((Double)radius).doubleValue());
        session.flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "drain " + this.location.toString(e, debug) + " in radius " + this.radius.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffDrain.class, (String[])new String[]{"drain [all] [(skematic|fawe)] [liquid[s]] at %location% (in|within) [a] radius [of] %number%"});
    }
}

