/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.efnilite.skematic.utils.FaweUtils;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.patterns.Pattern;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

@Name(value="Fill walls")
@Description(value={"Fill the walls of a cuboidregion with a pattern"})
@Since(value="2.1")
public class EffCuboidWalls
extends Effect {
    private Expression<CuboidRegion> cuboid;
    private Expression<ItemType> blocks;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.cuboid = expressions[0];
        this.blocks = expressions[1];
        return true;
    }

    protected void execute(Event e) {
        CuboidRegion cuboid = (CuboidRegion)this.cuboid.getSingle(e);
        ItemType[] blocks = (ItemType[])this.blocks.getArray(e);
        if (blocks == null || cuboid == null) {
            return;
        }
        EditSession session = FaweUtils.getEditSession(Bukkit.getServer().getWorld(cuboid.getWorld().getName()));
        session.makeCuboidWalls((Region)cuboid, (Pattern)FaweUtils.parsePattern(blocks));
        session.flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "fill walls of " + this.cuboid.toString(e, debug) + " with pattern " + this.blocks.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffCuboidWalls.class, (String[])new String[]{"fill walls of %cuboidregions% with %itemtypes%", "fill %cuboidregions%'[s] walls with %itemtypes%"});
    }
}

