/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.efnilite.skematic.utils.FaweUtils;
import com.sk89q.worldedit.EditSession;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Clear contents")
@Description(value={"Clear the contents of a container at a location."})
@Examples(value={"clear the contents of the container at 3, 73, 12 in \"world\""})
@Since(value="1.5")
public class EffClearContainer
extends Effect {
    private Expression<Location> location;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.location = expressions[0];
        return true;
    }

    protected void execute(Event e) {
        Location location = (Location)this.location.getSingle(e);
        if (location == null) {
            return;
        }
        EditSession session = FaweUtils.getEditSession(location.getWorld());
        session.clearContainerBlockContents(FaweUtils.toVector(location));
        session.flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "clear contents of " + this.location.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffClearContainer.class, (String[])new String[]{"(clear|delete) [the] [(fawe|skematic)] content[s] of [the] [container] at %location%"});
    }
}

