/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.efnilite.skematic.utils.FaweUtils;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

@Name(value="Cavify")
@Description(value={"Generate caves in a cuboidregion."})
@Since(value="1.5")
public class EffCave
extends Effect {
    private Expression<CuboidRegion> cuboid;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.cuboid = expressions[0];
        return true;
    }

    protected void execute(Event e) {
        CuboidRegion cuboid = (CuboidRegion)this.cuboid.getSingle(e);
        if (cuboid == null) {
            return;
        }
        EditSession session = FaweUtils.getEditSession(Bukkit.getServer().getWorld(cuboid.getWorld().getName()));
        try {
            session.addCaves((Region)cuboid);
        }
        catch (WorldEditException ex) {
            ex.printStackTrace();
        }
        session.flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "cavify " + this.cuboid.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffCave.class, (String[])new String[]{"cav(e|ify) %cuboidregions%"});
    }
}

