/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.boydti.fawe.bukkit.wrapper.AsyncWorld;
import org.bukkit.World;
import org.bukkit.event.Event;

@Name(value="AsyncWorld - Save")
@Description(value={"Save an AsyncWorld."})
@Examples(value={"save the async world \"lobby-6\""})
@Since(value="1.0")
public class EffAsyncWorldSave
extends Effect {
    private Expression<World> world;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.world = expressions[0];
        return true;
    }

    protected void execute(Event e) {
        World world = (World)this.world.getSingle(e);
        if (world == null) {
            return;
        }
        AsyncWorld.wrap((World)world).save();
    }

    public String toString(Event e, boolean debug) {
        return "save async world " + this.world.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffAsyncWorldSave.class, (String[])new String[]{"save [the] [(fawe|skematic)] async[hronous] %world%"});
    }
}

