/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.boydti.fawe.bukkit.wrapper.AsyncWorld;
import org.bukkit.WorldCreator;
import org.bukkit.event.Event;

@Name(value="AsyncWorld - Create")
@Description(value={"Create an AsyncWorld."})
@Examples(value={"create the async world called \"myworld\""})
@Since(value="1.0")
public class EffAsyncWorldCreate
extends Effect {
    private Expression<String> world;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.world = expressions[0];
        return true;
    }

    protected void execute(Event e) {
        String world = (String)this.world.getSingle(e);
        if (world == null) {
            return;
        }
        AsyncWorld.create((WorldCreator)new WorldCreator(world));
    }

    public String toString(Event e, boolean debug) {
        return "load async world " + this.world.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffAsyncWorldCreate.class, (String[])new String[]{"(create|load) [the] [(fawe|skematic)]async[hronous] [world] [(called|named)] %strings%", "(load|create) [(fawe|skematic)] world[s] [(called|named)] %strings% async[hronously]"});
    }
}

