/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.sk89q.worldedit.regions.CuboidRegion;
import org.bukkit.event.Event;

@Name(value="Selection dimensions")
@Description(value={"Get one of the region dimensions of a cuboidregion."})
@Since(value="1.5")
public class ExprCuboidRegionDimensions
extends SimpleExpression<Number> {
    private int mark;
    private Expression<CuboidRegion> cuboid;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.cuboid = expressions[0];
        this.mark = parseResult.mark;
        return true;
    }

    protected Number[] get(Event e) {
        CuboidRegion cuboid = (CuboidRegion)this.cuboid.getSingle(e);
        if (cuboid == null) {
            return null;
        }
        switch (this.mark) {
            case 1: {
                return new Number[]{cuboid.getLength()};
            }
            case 2: {
                return new Number[]{cuboid.getHeight()};
            }
            case 3: {
                return new Number[]{cuboid.getWidth()};
            }
        }
        return new Number[]{0};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public String toString(Event e, boolean debug) {
        return "dimensions of " + this.cuboid.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprCuboidRegionDimensions.class, Number.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] [(skematic|fawe)] (cuboid|we|worldedit)[ ]region (1\u00a6length|2\u00a6height|3\u00a6width) of %cuboidregions%", "[the] %cuboidregions%'s [(skematic|fawe)] (cuboid|we|worldedit)[ ]region (1\u00a6length|2\u00a6height|3\u00a6width)"});
    }
}

