/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.efnilite.skematic.utils.FaweUtils;
import com.sk89q.worldedit.EditSession;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Undo")
@Description(value={"Undo the last edit of a player."})
@Examples(value={"undo the last change of player"})
@Since(value="1.0")
public class EffUndo
extends Effect {
    private Expression<Player> player;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.player = expressions[0];
        return true;
    }

    protected void execute(Event e) {
        Player player = (Player)this.player.getSingle(e);
        if (player == null) {
            return;
        }
        EditSession session = FaweUtils.getPlayer(player).getNewEditSession();
        session.undo(session);
        session.flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "undo last change of " + this.player.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffUndo.class, (String[])new String[]{"undo [the] last [(fawe|fastasyncworldedit)] (action|change) of %player%"});
    }
}

