/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.efnilite.skematic.utils.FaweUtils;
import com.sk89q.worldedit.EditSession;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Shape - Sphere")
@Description(value={"Create a (hollow) sphere at a location"})
@Examples(value={"make a new hollow sphere at player with nether brick and netherrack blocks with radius 100"})
@Since(value="2.0")
public class EffShapeSphere
extends Effect {
    private int mark;
    private Expression<Location> location;
    private Expression<ItemType> blocks;
    private Expression<Number> radius;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.mark = parseResult.mark;
        this.location = expressions[0];
        this.blocks = expressions[1];
        this.radius = expressions[2];
        return true;
    }

    protected void execute(Event e) {
        Location location = (Location)this.location.getSingle(e);
        ItemType[] blocks = (ItemType[])this.blocks.getArray(e);
        Number radius = (Number)this.radius.getSingle(e);
        boolean filled = true;
        if (blocks == null || radius == null || location == null) {
            return;
        }
        if (this.mark == 1) {
            filled = false;
        }
        EditSession session = FaweUtils.getEditSession(location.getWorld());
        session.makeSphere(FaweUtils.toVector(location), FaweUtils.parsePattern(blocks), (double)Math.round(((Long)radius).longValue()), filled);
        session.flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "create sphere at " + this.location.toString(e, debug) + " with blocks " + this.blocks.toString(e, debug) + " with radius " + this.radius.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffShapeSphere.class, (String[])new String[]{"(make|create) [a] [new] [(1\u00a6hollow)] sphere at %location% (with|and) %itemtypes% [block[s]] (with|and) radius %number%"});
    }
}

