/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import com.efnilite.skematic.objects.SchematicLoader;
import org.bukkit.event.Event;

@Name(value="Unload schematic")
@Description(value={"Unload a saved schematic"})
@Examples(value={"unload skematic \"loaded-schematic\""})
@Since(value="2.1")
public class EffSchematicUnload
extends AsyncEffect {
    private Expression<String> schematic;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.schematic = expressions[0];
        return true;
    }

    protected void execute(Event e) {
        String schematic = (String)this.schematic.getSingle(e);
        if (schematic == null) {
            return;
        }
        SchematicLoader.remove(schematic);
    }

    public String toString(Event e, boolean debug) {
        return "load " + this.schematic.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffSchematicUnload.class, (String[])new String[]{"unload s(k|ch)em[atic] %strings%"});
    }
}

