/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import com.efnilite.skematic.objects.Schematic;
import com.efnilite.skematic.objects.SchematicLoader;
import java.io.File;
import org.bukkit.event.Event;

@Name(value="Load schematic")
@Description(value={"Load a schematic file (and store it in a variable)"})
@Examples(value={"load skematic \"plugins/WorldEdit/schematics/lobby-3.schematic\" as \"loaded-schematic\" stored in {skematic::lobby-3}"})
@Since(value="2.1")
public class EffSchematicLoad
extends AsyncEffect {
    private Expression<String> schematic;
    private Expression<String> alias;
    private Variable<?> var;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.schematic = expressions[0];
        this.alias = expressions[1];
        if (expressions[2] instanceof Variable) {
            this.var = (Variable)expressions[2];
        } else {
            Skript.error((String)"You can only store loaded schematics in variables!");
        }
        return true;
    }

    protected void execute(Event e) {
        String alias;
        String schematic = (String)this.schematic.getSingle(e);
        String string = alias = this.alias != null ? (String)this.alias.getSingle(e) : schematic;
        if (schematic == null) {
            return;
        }
        Schematic schem = new Schematic(new File(schematic));
        Object[] change = new Object[]{schem};
        if (this.var != null) {
            this.var.change(e, change, Changer.ChangeMode.SET);
        }
        SchematicLoader.add(alias, schem);
    }

    public String toString(Event e, boolean debug) {
        return "load " + this.schematic.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffSchematicLoad.class, (String[])new String[]{"load s(k|ch)em[atic] %strings% [as %-strings%] [[and] (store[d]|save) ([[the] s(k|ch)em[atic]]|it) (in|to) [variable] %-objects%]"});
    }
}

