/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.efnilite.skematic.utils.FaweUtils;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

@Name(value="Regenerate")
@Description(value={"Regenerate a cuboidregion."})
@Since(value="2.0")
public class EffRegenerate
extends Effect {
    private Expression<CuboidRegion> cuboid;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.cuboid = expressions[0];
        return true;
    }

    protected void execute(Event e) {
        CuboidRegion cuboid = (CuboidRegion)this.cuboid.getSingle(e);
        if (cuboid == null) {
            return;
        }
        EditSession session = FaweUtils.getEditSession(Bukkit.getServer().getWorld(cuboid.getWorld().getName()));
        session.regenerate((Region)cuboid);
        session.flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "regenerate " + this.cuboid.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffRegenerate.class, (String[])new String[]{"regenerate [cuboid[(-| )region]] %cuboidregions%"});
    }
}

