/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.sk89q.worldedit.regions.CuboidRegion;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Selection contains")
@Description(value={"Check whether the selection of a player contains a location."})
@Since(value="1.0")
public class CondSelectionContains
extends Condition {
    private Expression<CuboidRegion> cuboid;
    private Expression<Location> location;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.cuboid = expressions[0];
        this.location = expressions[1];
        return true;
    }

    public boolean check(Event e) {
        CuboidRegion cuboid = (CuboidRegion)this.cuboid.getSingle(e);
        Location location = (Location)this.location.getSingle(e);
        if (cuboid == null || location == null) {
            return false;
        }
        if (!cuboid.contains(location.getBlockX(), location.getBlockY(), location.getBlockZ())) {
            return !this.isNegated();
        }
        return this.isNegated();
    }

    public String toString(Event e, boolean debug) {
        return "if " + this.cuboid.toString(e, debug) + " contains " + this.location.toString(e, debug);
    }

    static {
        Skript.registerCondition(CondSelectionContains.class, (String[])new String[]{"%cuboidregions% contains %location%"});
    }
}

