/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import com.boydti.fawe.FaweAPI;
import com.efnilite.skematic.lang.SkematicPropertyExpression;
import com.efnilite.skematic.lang.annotations.PropertyExpression;
import com.efnilite.skematic.lang.annotations.Return;
import com.sk89q.worldedit.Vector;
import java.io.File;
import java.io.IOException;

@Name(value="Schematic size")
@Description(value={"Gets the size of a schematic."})
@Examples(value={"set {_size} to the size of skematic \"plugins/WorldEdit/skematic.schematic\""})
@Return(value=Vector.class)
@PropertyExpression
public class ExprSchematicSize
extends SkematicPropertyExpression<String, Vector> {
    public Vector convert(String f) {
        try {
            return FaweAPI.load((File)new File(f)).getClipboard().getDimensions();
        }
        catch (IOException e) {
            return null;
        }
    }

    protected String getPropertyName() {
        return "dimensions";
    }

    static {
        ExprSchematicSize.register(ExprSchematicSize.class, Vector.class, (String)"[(skematic|fawe)] [s(ch|k)em[atic]] dimensions", (String)"strings");
    }
}

