/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import com.boydti.fawe.FaweAPI;
import com.efnilite.skematic.lang.SkematicPropertyExpression;
import com.efnilite.skematic.lang.annotations.PropertyExpression;
import com.efnilite.skematic.lang.annotations.Return;
import com.sk89q.worldedit.Vector;
import java.io.File;
import java.io.IOException;

@Name(value="Schematic origin")
@Description(value={"Returns the origin location of a schematic (where it was copied and saved)"})
@Examples(value={"set {_origin} to the origin of \"plugins/WorldEdit/skematic.schematic\""})
@Return(value=Vector.class)
@PropertyExpression
public class ExprSchematicOrigin
extends SkematicPropertyExpression<String, Vector> {
    public Vector convert(String f) {
        try {
            return FaweAPI.load((File)new File(f)).getClipboard().getOrigin();
        }
        catch (IOException e) {
            return null;
        }
    }

    protected String getPropertyName() {
        return "origin";
    }

    static {
        ExprSchematicOrigin.register(ExprSchematicOrigin.class, Vector.class, (String)"[(skematic|fawe)] [s(ch|k)em[atic]] origin (location|area)", (String)"strings");
    }
}

