/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.ExpressionType;
import com.boydti.fawe.FaweAPI;
import com.efnilite.skematic.lang.SkematicExpression;
import com.efnilite.skematic.lang.annotations.Return;
import com.efnilite.skematic.lang.annotations.Single;
import com.sk89q.worldedit.Vector;
import java.io.File;
import java.io.IOException;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Schematic dimensions")
@Description(value={"Gets one of the schematic dimensions (width, length or height)"})
@Examples(value={"set {_width} to the width of the skematic \"plugins/WorldEdit/skematic.schematic\""})
@Return(value=Number.class)
@Single
public class ExprSchematicArea
extends SkematicExpression<Number> {
    @Nullable
    protected Number[] get(Event e) {
        Vector size;
        String s = (String)this.expressions[0].getSingle(e);
        if (s == null) {
            return null;
        }
        try {
            size = FaweAPI.load((File)new File(s)).getClipboard().getDimensions();
        }
        catch (IOException exception) {
            return null;
        }
        double t = 0.0;
        switch (this.mark) {
            case 1: {
                t = size.getY();
                break;
            }
            case 2: {
                t = size.getX();
                break;
            }
            case 3: {
                t = size.getZ();
                break;
            }
            case 4: {
                t = size.getZ() * size.getX();
            }
        }
        return new Number[]{t};
    }

    public String toString(Event e, boolean debug) {
        return "areas of " + this.expressions[0].toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprSchematicArea.class, Number.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] [(skematic|fawe)] (1\u00a6width|2\u00a6height|3\u00a6length|4\u00a6floor[(-| )]size) of [the] s(ch|k)em[atic] %string%"});
    }
}

