/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.util.coll.CollectionUtils;
import com.boydti.fawe.example.NMSMappedFaweQueue;
import com.boydti.fawe.util.SetQueue;
import com.efnilite.skematic.lang.SkematicExpression;
import com.efnilite.skematic.lang.annotations.Return;
import com.efnilite.skematic.lang.annotations.Single;
import com.efnilite.skematic.utils.FaweTools;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Light level")
@Description(value={"Get the light level of a block."})
@Return(value=Number.class)
@Single
public class ExprLightLevel
extends SkematicExpression<Number> {
    protected Number[] get(Event e) {
        Location location = (Location)this.expressions[0].getSingle(e);
        if (location == null) {
            return null;
        }
        return new Number[]{FaweTools.getWorld(location.getWorld().getName()).getBlockLightLevel(FaweTools.toVector(location))};
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Player[].class});
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            Location l = (Location)this.expressions[0].getSingle(e);
            if (l == null) {
                return;
            }
            NMSMappedFaweQueue n = (NMSMappedFaweQueue)SetQueue.IMP.getNewQueue(FaweTools.getWorld(l.getWorld().getName()), true, false);
            n.setBlockLight(l.getBlockX(), l.getBlockY(), l.getBlockZ(), ((Integer)delta[0]).intValue());
        }
    }

    public String toString(Event e, boolean debug) {
        return "block light at " + this.expressions[0].toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprLightLevel.class, Number.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] [(skematic|fawe)] [block(-| )]light of [the] [block] (at|of) %location%"});
    }
}

