/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.ExpressionType;
import com.efnilite.skematic.lang.SkematicExpression;
import com.efnilite.skematic.lang.annotations.Return;
import com.efnilite.skematic.lang.annotations.Single;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.regions.CuboidRegion;
import org.bukkit.event.Event;

@Name(value="Selection points")
@Description(value={"Gets the minimal or maximal points of a player's selection"})
@Examples(value={"set {_point} to the maximum point of player's selection"})
@Return(value=Vector.class)
@Single
public class ExprCuboidRegionPoints
extends SkematicExpression<Vector> {
    protected Vector[] get(Event e) {
        CuboidRegion cuboid = (CuboidRegion)this.expressions[0].getSingle(e);
        Vector vector = null;
        if (cuboid == null) {
            return null;
        }
        switch (this.mark) {
            case 1: {
                vector = cuboid.getMinimumPoint();
                break;
            }
            case 2: {
                vector = cuboid.getMinimumPoint();
            }
        }
        return new Vector[]{vector};
    }

    public String toString(Event e, boolean debug) {
        return "get min or max of " + this.expressions[0].toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprCuboidRegionPoints.class, Vector.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] [(skematic|fawe)] (1\u00a6min|2\u00a6max)[imum] (coord[inate]|point)[s] of %cuboidregions%", "%cuboidregions%'[s] [(skematic|fawe)] (1\u00a6min|2\u00a6max)[imum] (coord[inate]|point)[s]"});
    }
}

