/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.ExpressionType;
import com.efnilite.skematic.lang.SkematicExpression;
import com.efnilite.skematic.lang.annotations.Return;
import com.efnilite.skematic.lang.annotations.Single;
import com.sk89q.worldedit.regions.CuboidRegion;
import org.bukkit.event.Event;

@Name(value="Selection dimensions")
@Description(value={"Get one of the region dimensions of a player's selection."})
@Return(value=Number.class)
@Single
public class ExprCuboidRegionDimensions
extends SkematicExpression<Number> {
    protected Number[] get(Event e) {
        CuboidRegion cuboid = (CuboidRegion)this.expressions[0].getSingle(e);
        if (cuboid == null) {
            return null;
        }
        double t = 0.0;
        switch (this.mark) {
            case 1: {
                t = cuboid.getLength();
                break;
            }
            case 2: {
                t = cuboid.getHeight();
                break;
            }
            case 3: {
                t = cuboid.getWidth();
            }
        }
        return new Number[]{t};
    }

    public String toString(Event e, boolean debug) {
        return "get height of " + this.expressions[0].toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprCuboidRegionDimensions.class, Number.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] [(skematic|fawe)] (cuboid|we|worldedit)[ ]region (1\u00a6length|2\u00a6height|3\u00a6width) of %cuboidregions%", "[the] %cuboidregions%'s [(skematic|fawe)] (cuboid|we|worldedit)[ ]region (1\u00a6length|2\u00a6height|3\u00a6width)"});
    }
}

