/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.ExpressionType;
import com.efnilite.skematic.lang.SkematicExpression;
import com.efnilite.skematic.lang.annotations.Return;
import com.efnilite.skematic.lang.annotations.Single;
import com.efnilite.skematic.utils.FaweTools;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Countable;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.event.Event;

@Name(value="Block count")
@Description(value={"Get the block count in a cuboidregion"})
@Examples(value={"command /glass:", "\ttrigger:", "\t\tsend \"%size of glass in player's selection%\""})
@Return(value=Number.class)
@Single
public class ExprCuboidRegionBlocksCount
extends SkematicExpression<Number> {
    protected Number[] get(Event e) {
        ItemType item = (ItemType)this.expressions[0].getSingle(e);
        CuboidRegion cuboid = (CuboidRegion)this.expressions[1].getSingle(e);
        if (cuboid == null || item == null) {
            return null;
        }
        boolean count = false;
        EditSession session = FaweTools.getEditSession(Bukkit.getServer().getWorld(cuboid.getWorld().getName()));
        List blocks = session.getBlockDistributionWithData((Region)cuboid);
        for (Countable block : blocks) {
            if (Material.getMaterial((int)((BaseBlock)block.getID()).getId()) != item.getRandom().getType()) continue;
            return new Number[]{block.getAmount()};
        }
        return new Number[]{0};
    }

    public String toString(Event e, boolean debug) {
        return "get blocks of " + this.expressions[0].toString(e, debug) + " in " + this.expressions[1].toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprCuboidRegionBlocksCount.class, Number.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[(skematic|fawe)] (size|amount) of %itemtypes% in [region] %cuboidregions%", "%cuboidregions%'[s] [(skematic|fawe)] (size|amount) of %itemtypes%"});
    }
}

