/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.ExpressionType;
import com.efnilite.skematic.lang.SkematicExpression;
import com.efnilite.skematic.lang.annotations.Return;
import com.efnilite.skematic.utils.FaweTools;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Countable;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

@Name(value="All blocks")
@Description(value={"Get all blocks in a cuboidregion"})
@Return(value=ItemType.class)
public class ExprCuboidRegionBlocks
extends SkematicExpression<ItemType> {
    protected ItemType[] get(Event e) {
        CuboidRegion cuboid = (CuboidRegion)this.expressions[0].getSingle(e);
        if (cuboid == null) {
            return null;
        }
        EditSession session = FaweTools.getEditSession(Bukkit.getServer().getWorld(cuboid.getWorld().getName()));
        List blocks = session.getBlockDistributionWithData((Region)cuboid);
        ArrayList<ItemType> materials = new ArrayList<ItemType>();
        if (blocks == null) {
            return null;
        }
        for (Countable block : blocks) {
            materials.add(new ItemType(((BaseBlock)block.getID()).getId()));
        }
        return materials.toArray(new ItemType[0]);
    }

    public String toString(Event e, boolean debug) {
        return "get all blocks in " + this.expressions[0].toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprCuboidRegionBlocks.class, ItemType.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[all] [of] [the] [skematic] blocks in %cuboidregions%", "[all] [of] %cuboidregions%'s [skematic] blocks"});
    }
}

