/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import com.efnilite.skematic.lang.SkematicEffect;
import com.efnilite.skematic.utils.FaweTools;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.Vector;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Snowify")
@Description(value={"Place snow at a location - Let it go."})
@Examples(value={"snowify 1, 3, 19 in \"world\" within a radius of 10"})
public class EffSnowy
extends SkematicEffect {
    protected void execute(Event e) {
        Location location = (Location)this.expressions[0].getSingle(e);
        Number radius = (Number)this.expressions[1].getSingle(e);
        if (location == null || radius == null) {
            return;
        }
        EditSession session = FaweTools.getEditSession(location.getWorld());
        session.simulateSnow(new Vector(location.getBlockX(), location.getBlockY(), location.getBlockZ()), ((Double)radius).doubleValue());
        session.flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "snowify " + this.expressions[0].toString(e, debug) + " with radius " + this.expressions[1].toString(e, debug);
    }

    static {
        Skript.registerEffect(EffSnowy.class, (String[])new String[]{"(sim[ulate] snow at|place snow at|snowify) %location% (in|within) [a] radius [of] %number%"});
    }
}

