/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.util.Direction;
import com.efnilite.skematic.lang.SkematicEffect;
import com.efnilite.skematic.utils.FaweTools;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.Vector;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Shape - Sphere")
@Description(value={"Create a (hollow) sphere at a location"})
public class EffShapeSphere
extends SkematicEffect {
    protected void execute(Event e) {
        Location location = (Location)Direction.combine((Expression)this.expressions[0], (Expression)this.expressions[1]);
        ItemType[] blocks = (ItemType[])this.expressions[2].getAll(e);
        Number size = (Number)this.expressions[3].getSingle(e);
        boolean filled = true;
        if (blocks == null || size == null) {
            return;
        }
        if (this.mark == 1) {
            filled = false;
        }
        EditSession session = FaweTools.getEditSession(location.getWorld());
        session.makeSphere(new Vector(location.getBlockX(), location.getBlockY(), location.getBlockZ()), FaweTools.parsePattern(blocks), (double)Math.round(((Long)size).longValue()), filled);
        session.flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "create sphere at " + this.expressions[1].toString(e, debug) + " with blocks " + this.expressions[1].toString(e, debug) + " with radius " + this.expressions[2].toString(e, debug);
    }

    static {
        Skript.registerEffect(EffShapeSphere.class, (String[])new String[]{"(make|create) [a] [new] [(1\u00a6hollow)] sphere %direction% %location% (with|and) pattern %string% (with|and) radius %number%"});
    }
}

