/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.util.Direction;
import com.efnilite.skematic.lang.SkematicEffect;
import com.efnilite.skematic.utils.FaweTools;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.Vector;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Shape - Pyramid")
@Description(value={"Create a (hollow) pyramid at a location."})
@Examples(value={"create a new pyramid at player's location with stone and size 3"})
public class EffShapePyramid
extends SkematicEffect {
    protected void execute(Event e) {
        Location location = (Location)Direction.combine((Expression)this.expressions[0], (Expression)this.expressions[1]);
        ItemType[] blocks = (ItemType[])this.expressions[2].getAll(e);
        Number size = (Number)this.expressions[3].getSingle(e);
        boolean filled = true;
        if (blocks == null || size == null) {
            return;
        }
        if (this.mark == 1) {
            filled = false;
        }
        EditSession session = FaweTools.getEditSession(location.getWorld());
        session.makePyramid(new Vector(location.getBlockX(), location.getBlockY(), location.getBlockZ()), FaweTools.parsePattern(blocks), Math.round(((Long)size).longValue()), filled);
        session.flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "create pyramid at " + this.expressions[1].toString(e, debug) + " with blocks " + this.expressions[1].toString(e, debug) + " with radius " + this.expressions[2].toString(e, debug);
    }

    static {
        Skript.registerEffect(EffShapePyramid.class, (String[])new String[]{"(make|create) [a] [new] [(1\u00a6hollow)] pyramid %direction% %location% (with|and) [(itemtypes[s]|block[s]|pattern)] %itemtypes% (with|and) size %number%"});
    }
}

