/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.util.Direction;
import com.efnilite.skematic.lang.SkematicEffect;
import com.efnilite.skematic.utils.FaweTools;
import com.sk89q.worldedit.EditSession;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Shape - Line")
@Description(value={"Create a line between 2 locations"})
public class EffShapeLine
extends SkematicEffect {
    protected void execute(Event e) {
        Location location1 = (Location)Direction.combine((Expression)this.expressions[0], (Expression)this.expressions[1]);
        Location location2 = (Location)Direction.combine((Expression)this.expressions[2], (Expression)this.expressions[3]);
        ItemType[] blocks = (ItemType[])this.expressions[4].getAll(e);
        Number radius = (Number)this.expressions[5].getSingle(e);
        boolean filled = true;
        if (blocks == null || radius == null) {
            return;
        }
        if (this.mark == 1) {
            filled = false;
        }
        EditSession session = FaweTools.getEditSession(location1.getWorld());
        session.drawLine(FaweTools.parsePattern(blocks), FaweTools.toVector(location1), FaweTools.toVector(location2), (double)Math.round(((Long)radius).longValue()), filled);
        session.flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "create a line between " + this.expressions[1].toString(e, debug) + " and " + this.expressions[3].toString(e, debug) + " with pattern " + this.expressions[4].toString(e, debug);
    }

    static {
        Skript.registerEffect(EffShapeLine.class, (String[])new String[]{"(make|create) [a] [new] [(1\u00a6hollow)] line from %direction% %location% to %direction% %location% (with|and) [(itemtypes[s]|block[s]|pattern)] %itemtypes% (with|and) radius %number%"});
    }
}

