/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.util.Direction;
import com.efnilite.skematic.lang.SkematicEffect;
import com.efnilite.skematic.utils.FaweTools;
import com.sk89q.worldedit.EditSession;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Shape - Hollow cylinder")
@Description(value={"Create a hollow cylinder at a location."})
@Examples(value={"make a new hollow cylinder at player's location with blocks grass and dirt with x radius 2 and z radius 2 and thickness 1 and height 4"})
public class EffShapeHollowCylinder
extends SkematicEffect {
    protected void execute(Event e) {
        Location location = (Location)Direction.combine((Expression)this.expressions[0], (Expression)this.expressions[1]);
        ItemType[] blocks = (ItemType[])this.expressions[2].getAll(e);
        Number x = (Number)this.expressions[3].getSingle(e);
        Number z = (Number)this.expressions[4].getSingle(e);
        Number thickness = (Number)this.expressions[5].getSingle(e);
        Number height = (Number)this.expressions[6].getSingle(e);
        if (blocks == null || x == null || z == null || thickness == null || height == null) {
            return;
        }
        EditSession session = FaweTools.getEditSession(location.getWorld());
        session.makeHollowCylinder(FaweTools.toVector(location), FaweTools.parsePattern(blocks), ((Double)x).doubleValue(), ((Double)z).doubleValue(), Math.round(((Long)height).longValue()), ((Double)thickness).doubleValue());
        session.flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "create hollow cylinder at " + this.expressions[1].toString(e, debug) + " with blocks " + this.expressions[1].toString(e, debug) + " with x " + this.expressions[2].toString(e, debug) + " with z " + this.expressions[3].toString(e, debug) + " with thickness " + this.expressions[4].toString(e, debug) + " with height " + this.expressions[5].toString(e, debug);
    }

    static {
        Skript.registerEffect(EffShapeHollowCylinder.class, (String[])new String[]{"(make|create) [a] [new] hollow cylinder at %location% (with|and) [(itemtypes[s]|block[s]|pattern)] %itemtypes% (with|and) x[(-| )]radius %number% (with|and) z[(-| )]radius %number% (with|and) thickness %number% (with|and) height %number%"});
    }
}

