/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.util.Direction;
import com.efnilite.skematic.lang.SkematicEffect;
import com.efnilite.skematic.utils.FaweTools;
import com.sk89q.worldedit.EditSession;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Shape - Cylinder")
@Description(value={"Create a cylinder at a location"})
@Examples(value={"create a cylinder at {_location} with pattern grass, glass and stone and radius 1 and height 2"})
public class EffShapeCylinder
extends SkematicEffect {
    protected void execute(Event e) {
        Location location = (Location)Direction.combine((Expression)this.expressions[0], (Expression)this.expressions[1]);
        ItemType[] blocks = (ItemType[])this.expressions[2].getAll(e);
        Number radius = (Number)this.expressions[3].getSingle(e);
        Number height = (Number)this.expressions[4].getSingle(e);
        boolean filled = true;
        if (blocks == null || radius == null) {
            return;
        }
        if (this.mark == 1) {
            filled = false;
        }
        EditSession session = FaweTools.getEditSession(location.getWorld());
        session.makeCylinder(FaweTools.toVector(location), FaweTools.parsePattern(blocks), (double)Math.round(((Long)radius).longValue()), Math.round(((Long)height).longValue()), filled);
        session.flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "create cylinder at " + this.expressions[0].toString(e, debug) + " with blocks " + this.expressions[1].toString(e, debug) + " with radius " + this.expressions[2].toString(e, debug) + " and height " + this.expressions[3].toString(e, debug);
    }

    static {
        Skript.registerEffect(EffShapeCylinder.class, (String[])new String[]{"(make|create) [a] [new] [(1\u00a6hollow)] cylinder %direction% %location% (with|and) [(itemtypes[s]|block[s]|pattern)] %itemtypes% (with|and) radius %number% (with|and) height %number%"});
    }
}

