/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import com.boydti.fawe.object.schematic.Schematic;
import com.efnilite.skematic.Skematic;
import com.efnilite.skematic.lang.SkematicEffect;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.bukkit.event.Event;

@Name(value="Save schematic")
@Description(value={"Create a new schematic."})
@Examples(value={"save schematic selection of player to the file \"plugins/schematic.schematic\" with format schematic"})
public class EffSaveSchematic
extends SkematicEffect {
    protected void execute(Event e) {
        CuboidRegion cuboid = (CuboidRegion)this.expressions[0].getSingle(e);
        String schematic = (String)this.expressions[1].getSingle(e);
        ClipboardFormat format = (ClipboardFormat)this.expressions[2].getSingle(e);
        if (cuboid == null || schematic == null) {
            return;
        }
        if (format == null) {
            format = ClipboardFormat.SCHEMATIC;
        }
        Schematic file = new Schematic((Region)cuboid);
        try {
            file.save(new File(schematic), format);
        }
        catch (IOException ex) {
            Skematic.log("Could not save schematic " + schematic + " with format " + format, Level.SEVERE);
        }
    }

    public String toString(Event e, boolean debug) {
        return "save schematic " + this.expressions[1].toString(e, debug) + " with region " + this.expressions[0].toString(e, debug) + (this.expressions[2] != null ? " with format " + this.expressions[2].toString(e, debug) : "");
    }

    static {
        Skript.registerEffect(EffSaveSchematic.class, (String[])new String[]{"save [[the] s(ch|k)ematic] %cuboidregions% to [[the] file] %string% [with %-schematicformat% format]"});
    }
}

