/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import com.efnilite.skematic.lang.SkematicEffect;
import com.efnilite.skematic.utils.FaweTools;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import java.util.HashSet;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

@Name(value="Replace blocks")
@Description(value={"Replace all blocks with other blocks in a cuboidregion"})
@Examples(value={"replace all fawe stone and gravel with blocks air in (player's selection)"})
public class EffReplaceBlocks
extends SkematicEffect {
    protected void execute(Event e) {
        ItemType[] target = (ItemType[])this.expressions[0].getSingle(e);
        ItemType[] replacement = (ItemType[])this.expressions[1].getSingle(e);
        CuboidRegion cuboid = (CuboidRegion)this.expressions[2].getSingle(e);
        if (cuboid == null || target == null || replacement == null) {
            return;
        }
        HashSet<BaseBlock> set = new HashSet<BaseBlock>();
        for (ItemType type : target) {
            set.add(new BaseBlock(type.getRandom().getType().getId()));
        }
        EditSession session = FaweTools.getEditSession(Bukkit.getServer().getWorld(cuboid.getWorld().getName()));
        session.replaceBlocks((Region)cuboid, set, FaweTools.parsePattern(replacement));
        session.flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "place fast at " + this.expressions[0].toString(e, debug);
    }

    static {
        Skript.registerEffect(EffReplaceBlocks.class, (String[])new String[]{"replace [all] [(fawe|skematic)] [(block[s]|item[type[s]])] %itemtypes% with (block[s]|item[type[s]]) %itemtypes% in %cuboidregions%"});
    }
}

