/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.util.Direction;
import com.boydti.fawe.FaweAPI;
import com.efnilite.skematic.Skematic;
import com.efnilite.skematic.lang.SkematicEffect;
import com.efnilite.skematic.utils.FaweTools;
import com.sk89q.worldedit.CuboidClipboard;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.world.DataException;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Paste schematic")
@Description(value={"Paste a schematic at a location with or without using air"})
@Examples(value={"paste skematic \"plugins/WorldEdit/skematic.schematic\" at player excluding air"})
public class EffPasteSchematic
extends SkematicEffect {
    protected void execute(Event e) {
        String schematic = (String)this.expressions[0].getSingle(e);
        Location location = (Location)Direction.combine((Expression)this.expressions[1], (Expression)this.expressions[2]);
        Number angle = (Number)this.expressions[3].getSingle(e);
        if (schematic == null) {
            return;
        }
        File file = new File(schematic);
        boolean ignoreAir = true;
        boolean allowUndo = false;
        switch (this.mark) {
            case 1: {
                ignoreAir = false;
                break;
            }
            case 2: {
                allowUndo = true;
                break;
            }
            case 3: {
                ignoreAir = true;
                allowUndo = true;
                break;
            }
        }
        if (!schematic.endsWith(".schematic")) {
            file = new File(schematic + ".schematic");
        }
        Vector vector = FaweTools.toVector(location);
        if (angle != null) {
            CuboidClipboard clipboard;
            EditSession session = FaweTools.getEditSession(location.getWorld());
            try {
                clipboard = CuboidClipboard.loadSchematic((File)file);
            }
            catch (DataException | IOException ex) {
                return;
            }
            if (clipboard != null) {
                clipboard.rotate2D(((Integer)angle).intValue());
            }
            try {
                clipboard.paste(session, vector, ignoreAir);
            }
            catch (MaxChangedBlocksException exception) {
                Skematic.log("Could not paste schematic " + file, Level.SEVERE);
                return;
            }
            session.flushQueue();
        } else {
            try {
                FaweAPI.load((File)file).paste(FaweTools.getWorld(location.getWorld().getName()), vector, allowUndo, ignoreAir, null);
            }
            catch (IOException ex) {
                Skematic.log("Could not paste schematic " + file, Level.SEVERE);
            }
        }
    }

    public String toString(Event e, boolean debug) {
        return "paste schematic " + this.expressions[0].toString(e, debug) + " at " + this.expressions[1].toString(e, debug) + (this.expressions[3] != null ? " with angle " + this.expressions[3].toString(e, debug) : "");
    }

    static {
        Skript.registerEffect(EffPasteSchematic.class, (String[])new String[]{"paste [the] s(ch|k)em[atic] %string% %direction% %location% [(1\u00a6(without|excluding) air)] [(2\u00a6[(,| and)] allow[ing] undo)] [[with] angle %-number%]"});
    }
}

