/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.util.Direction;
import com.efnilite.skematic.lang.SkematicEffect;
import com.efnilite.skematic.utils.FaweTools;
import com.sk89q.worldedit.EditSession;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Greenify")
@Description(value={"Greenify an area - Turns it into grass."})
@Examples(value={"greenify 2, 3, 4 in \"world\" within a radius of 20"})
public class EffGreen
extends SkematicEffect {
    protected void execute(Event e) {
        Location location = (Location)Direction.combine((Expression)this.expressions[0], (Expression)this.expressions[1]);
        Number radius = (Number)this.expressions[2].getSingle(e);
        boolean dirt = false;
        if (radius == null) {
            return;
        }
        if (this.mark == 1) {
            dirt = true;
        }
        EditSession session = FaweTools.getEditSession(location.getWorld());
        session.green(FaweTools.toVector(location), ((Double)radius).doubleValue(), dirt);
        session.flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "grassify " + this.expressions[0].toString(e, debug) + " with radius " + this.expressions[1].toString(e, debug);
    }

    static {
        Skript.registerEffect(EffGreen.class, (String[])new String[]{"(green|grass)[ify] %direction% %location% (in|within) [a] radius [of] %number% (1\u00a6[(with|and)] only [normal] dirt)"});
    }
}

