/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.util.Direction;
import com.efnilite.skematic.lang.SkematicEffect;
import com.efnilite.skematic.utils.FaweTools;
import com.sk89q.worldedit.EditSession;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Drain liquids")
@Description(value={"Drain all liquids at a certain location with a radius."})
@Examples(value={"drain all liquids at 124, 32, 12 in \"world\" in a radius of 10"})
public class EffDrain
extends SkematicEffect {
    protected void execute(Event e) {
        Location location = (Location)Direction.combine((Expression)this.expressions[0], (Expression)this.expressions[1]);
        Number radius = (Number)this.expressions[2].getSingle(e);
        if (radius == null) {
            return;
        }
        EditSession session = FaweTools.getEditSession(location.getWorld());
        session.drainArea(FaweTools.toVector(location), ((Double)radius).doubleValue());
        session.flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "drain " + this.expressions[1].toString(e, debug) + " in radius " + this.expressions[1].toString(e, debug);
    }

    static {
        Skript.registerEffect(EffDrain.class, (String[])new String[]{"drain [all] [(skematic|fawe)] [liquid[s]] %direction% %location% (in|within) [a] radius [of] %number%"});
    }
}

