/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import com.efnilite.skematic.lang.SkematicEffect;
import com.efnilite.skematic.utils.FaweTools;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

@Name(value="Fill Region")
@Description(value={"Fill a region (selection) with a block."})
public class EffCuboidFill
extends SkematicEffect {
    protected void execute(Event e) {
        CuboidRegion cuboid = (CuboidRegion)this.expressions[0].getSingle(e);
        ItemType[] blocks = (ItemType[])this.expressions[1].getAll(e);
        if (cuboid == null || blocks == null) {
            return;
        }
        EditSession session = FaweTools.getEditSession(Bukkit.getServer().getWorld(cuboid.getWorld().getName()));
        session.setBlocks((Region)cuboid, FaweTools.parsePattern(blocks));
        session.flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "fill" + this.expressions[0].toString(e, debug) + " with " + this.expressions[1].toString(e, debug);
    }

    static {
        Skript.registerEffect(EffCuboidFill.class, (String[])new String[]{"set [(all [[of] the]|the)] [(fawe|skematic)] blocks in %cuboidregions% to %itemtypes%"});
    }
}

