/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.util.Direction;
import com.efnilite.skematic.lang.SkematicEffect;
import com.efnilite.skematic.utils.FaweTools;
import com.sk89q.worldedit.EditSession;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Clear contents")
@Description(value={"Clear the contents of a container at a location."})
@Examples(value={"clear the contents of the container at 3, 73, 12 in \"world\""})
public class EffClearContainer
extends SkematicEffect {
    protected void execute(Event e) {
        Location location = (Location)Direction.combine((Expression)this.expressions[0], (Expression)this.expressions[1]);
        EditSession session = FaweTools.getEditSession(location.getWorld());
        session.clearContainerBlockContents(FaweTools.toVector(location));
        session.flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "clear contents of " + this.expressions[1].toString(e, debug);
    }

    static {
        Skript.registerEffect(EffClearContainer.class, (String[])new String[]{"(clear|delete) [the] [(fawe|skematic)] content[s] of [the] [container] %direction% %location%"});
    }
}

