/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import com.efnilite.skematic.lang.SkematicCondition;
import com.sk89q.worldedit.regions.CuboidRegion;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Selection contains")
@Description(value={"Check whether the selection of a player contains a location."})
public class CondSelectionContains
extends SkematicCondition {
    public boolean check(Event e) {
        CuboidRegion cuboid = (CuboidRegion)this.expressions[0].getSingle(e);
        Location location = (Location)this.expressions[1].getSingle(e);
        if (cuboid == null || location == null) {
            return false;
        }
        if (!cuboid.contains(location.getBlockX(), location.getBlockY(), location.getBlockZ())) {
            return !this.isNegated();
        }
        return this.isNegated();
    }

    public String toString(Event e, boolean debug) {
        return "if " + this.expressions[1].toString(e, debug) + " is in " + this.expressions[0].toString(e, debug);
    }

    static {
        Skript.registerCondition(CondSelectionContains.class, (String[])new String[]{"%cuboidregions% contains %location%"});
    }
}

