/*
 * Decompiled with CFR 0.152.
 */
package me.efnilite.skematic.elements.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.boydti.fawe.FaweAPI;
import com.sk89q.worldedit.Vector;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import me.efnilite.skematic.Skematic;

@Name(value="Schematic size")
@Description(value={"Gets the size of a schematic."})
@Examples(value={"set {_size} to the size of skematic \"plugins/WorldEdit/skematic.schematic\""})
@Since(value="1.0.0")
public class ExprSchematicSize
extends SimplePropertyExpression<String, Vector> {
    public Vector convert(String f) {
        Vector d;
        try {
            d = FaweAPI.load((File)new File(f)).getClipboard().getDimensions();
        }
        catch (FileNotFoundException exception) {
            Skematic.log("File " + f + " was not found!", Level.SEVERE);
            return null;
        }
        catch (IOException exception) {
            exception.printStackTrace();
            return null;
        }
        if (d == null) {
            return null;
        }
        return d;
    }

    protected String getPropertyName() {
        return "origin location";
    }

    public Class<Vector> getReturnType() {
        return Vector.class;
    }

    static {
        ExprSchematicSize.register(ExprSchematicSize.class, Vector.class, (String)"[s(ch|k)em[atic]] dimensions", (String)"strings");
    }
}

