/*
 * Decompiled with CFR 0.152.
 */
package me.efnilite.skematic.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.boydti.fawe.example.NMSMappedFaweQueue;
import com.boydti.fawe.util.SetQueue;
import com.sk89q.worldedit.Vector;
import me.efnilite.skematic.utils.FaweTools;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Light level")
@Description(value={"Get the light level of a block."})
@Examples(value={"set {light} to the block light of the block at 2, 3, 4 in \"lightworld\""})
@Since(value="1.0.0")
public class ExprLightLevel
extends SimpleExpression<Number> {
    private Expression<Location> location;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.location = exprs[0];
        return true;
    }

    protected Number[] get(Event e) {
        Location l = (Location)this.location.getSingle(e);
        if (l == null) {
            return null;
        }
        return new Number[]{FaweTools.getWorld(l.getWorld().getName()).getBlockLightLevel(new Vector(l.getBlockX(), l.getBlockY(), l.getBlockZ()))};
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Player[].class});
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            Location l = (Location)this.location.getSingle(e);
            if (l == null) {
                return;
            }
            NMSMappedFaweQueue n = (NMSMappedFaweQueue)SetQueue.IMP.getNewQueue(FaweTools.getWorld(l.getWorld().getName()), true, false);
            n.setBlockLight(l.getBlockX(), l.getBlockY(), l.getBlockZ(), ((Integer)delta[0]).intValue());
        }
    }

    public String toString(Event e, boolean debug) {
        return "light level at " + this.location.toString(e, debug);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    static {
        Skript.registerExpression(ExprLightLevel.class, Number.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] [block(-| )]light of [the] [block] (at|of) %location%"});
    }
}

