/*
 * Decompiled with CFR 0.152.
 */
package me.efnilite.skematic.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.regions.CuboidRegion;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

public class ExprCuboidRegionBlocksCount
extends SimpleExpression<Number> {
    private Expression<Block> material;
    private Expression<CuboidRegion> region;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.material = exprs[0];
        this.region = exprs[1];
        return true;
    }

    protected Number[] get(Event e) {
        Block m = (Block)this.material.getSingle(e);
        CuboidRegion r = (CuboidRegion)this.region.getSingle(e);
        if (r == null || m == null) {
            return null;
        }
        Vector pos1 = r.getPos1();
        Vector pos2 = r.getPos2();
        World w = Bukkit.getServer().getWorld(r.getWorld().getName());
        int blocks = 0;
        for (int x = pos1.getBlockX(); x <= pos2.getBlockX(); ++x) {
            for (int y = pos1.getBlockY(); y <= pos2.getBlockY(); ++y) {
                for (int z = pos1.getBlockZ(); z <= pos2.getBlockZ(); ++z) {
                    Material block = w.getBlockAt(x, y, z).getType();
                    if (block != m.getType()) continue;
                    ++blocks;
                }
            }
        }
        return new Number[]{blocks};
    }

    public String toString(Event e, boolean debug) {
        return "amount of " + this.material.getSingle(e) + " in " + this.region.toString(e, debug);
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    static {
        Skript.registerExpression(ExprCuboidRegionBlocksCount.class, Number.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[skematic] (size|amount) of %block% in [region] %cuboidregions%", "%cuboidregions%'s (size|amount) of %block%"});
    }
}

